<?php
/* Inferno Quiz Auto Installer */


// ######################## SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// ##################### DEFINE IMPORTANT CONSTANTS #######################
define('CVS_REVISION', '$RCSfile: install_quiz.php,v $ - $Revision: 1.0 $');
define('NO_REGISTER_GLOBALS', 1);

// #################### PRE-CACHE TEMPLATES AND DATA ######################
$phrasegroups = array();
$specialtemplates = array();

require_once('./global.php');
require_once(DIR . '/includes/adminfunctions_template.php');

class SystemRoutine{
var $options = array(
			'Fresh'     => '   ',
			'Upgrade_1' => '  (  v1.x  v2.0 )',
			'Uninstall' => '   ( v2.0  )',
			'Template' => '     ',
		);
var $queries = array();

	function buildQueries(){
	$this->queries[] = array(
			'type'      => array('Fresh'),
			'install'   => "CREATE TABLE `{TABLE_PREFIX}quiz` (
`qid` INT( 15 ) NOT NULL AUTO_INCREMENT ,
`q_name` VARCHAR( 255 ) NOT NULL default '0',
`q_state` TINYINT( 2 ) NOT NULL default '0',
`q_perms` text not null,
`q_start` int(15) not null default '0',
`q_end` int(15) not null default '0',
`q_autoend` tinyint(2) not null default '0',
`q_timelimit` int(8) not null default '0',
`q_viewanswer` tinyint(2) not null default '0',
PRIMARY KEY ( `qid` ) 
) TYPE = MYISAM;",
			'uninstall' => "drop table {TABLE_PREFIX}quiz",
			);
	$this->queries[] = array(
			'type'      => array('Fresh'),
			'install'   => "CREATE TABLE `{TABLE_PREFIX}quiz_questions` (
`qqid` INT( 15 ) NOT NULL AUTO_INCREMENT ,
`q_question` text NOT NULL default '',
`q_type` varchar(255) NOT NULL default '',
`q_params` text not null,
`q_forquiz` int(15) not null default '0',
PRIMARY KEY ( `qqid` ) 
) TYPE = MYISAM;",
			'uninstall' => "drop table {TABLE_PREFIX}quiz_questions",
			);
	$this->queries[] = array(
			'type'      => array('Fresh'),
			'install'   => "CREATE TABLE `{TABLE_PREFIX}quiz_results` (
`rid` INT( 15 ) NOT NULL AUTO_INCREMENT ,
`r_data` text NOT NULL default '',
`r_userid` int(15) not null default '0',
`r_score` int(4) not null default '0',
`r_forquiz` int(15) not null default '0',
PRIMARY KEY ( `rid` ) 
) TYPE = MYISAM;",
			'uninstall' => "drop table {TABLE_PREFIX}quiz_results",
			);
	$this->queries[] = array(
			'type'      => array('Fresh','Upgrade_1'),
			'install'   => "alter table {TABLE_PREFIX}quiz
add `q_image` varchar(255) not null default ''",
			'uninstall' => "",
			);
	$this->queries[] = array(
			'type'      => array('Fresh','Upgrade_1'),
			'install'   => "alter table {TABLE_PREFIX}quiz
add `q_desc` varchar(255) not null default ''",
			'uninstall' => "",
			);
	$this->queries[] = array(
			'type'      => array('Fresh','Upgrade_1'),
			'install'   => "alter table {TABLE_PREFIX}quiz
add `q_forcat` int(15) not null default '0'",
			'uninstall' => "",
			);
	$this->queries[] = array(
			'type'      => array('Fresh','Upgrade_1'),
			'install'   => "update {TABLE_PREFIX}quiz set q_forcat = 1",
			'uninstall' => "",
			);
	$this->queries[] = array(
			'type'      => array('Fresh','Upgrade_1'),
			'install'   => "CREATE TABLE `{TABLE_PREFIX}quiz_category` (
`cid` INT( 15 ) NOT NULL AUTO_INCREMENT ,
`c_name` VARCHAR( 255 ) NOT NULL default '',
`c_desc` VARCHAR( 255 ) NOT NULL default '',
`c_num` int(15) not null default '0',
PRIMARY KEY ( `cid` ) 
) TYPE = MYISAM;",
			'uninstall' => "drop table {TABLE_PREFIX}quiz_category",
			);
	$this->queries[] = array(
			'type'      => array('Fresh','Upgrade_1'),
			'install'   => "CREATE TABLE `{TABLE_PREFIX}quiz_submissions` (
`sid` INT( 15 ) NOT NULL AUTO_INCREMENT ,
`s_from` INT( 15 ) NOT NULL default '0',
`s_name` VARCHAR( 255 ) NOT NULL default '',
`s_desc` VARCHAR( 255 ) NOT NULL default '',
`s_image` VARCHAR( 255 ) NOT NULL default '',
`s_data` mediumtext not null default '',
`s_cat` INT( 15 ) NOT NULL default '0',
PRIMARY KEY ( `sid` ) 
) TYPE = MYISAM;",
			'uninstall' => "drop table {TABLE_PREFIX}quiz_submissions",
			);
	$this->queries[] = array(
			'type'      => array('Fresh','Upgrade_1'),
			'install'   => "insert into {TABLE_PREFIX}quiz_category (`cid`,`c_name`,`c_desc`) values (1,' ','   ')",
			'uninstall' => "",
			);
	}

	function killQuizTemplates($DB,$TablePrefix){
	$DB->query("delete from `{$TablePrefix}template` where `title` LIKE '%quiz%'");
	}

	function installQuizTemplates($DB,$TablePrefix,$XML){
	global $vbulletin, $vbphrase;

	$All_Styles = $DB->query("select styleid from {$TablePrefix}style where parentid < 0"); // Grab master styles only

		while($SID = $DB->fetch_array($All_Styles)){
		$ID[] = $SID['styleid'];
		}

		foreach($ID as $StyleID){
		xml_import_style($XML, $StyleID, -1, '', 1);
		}

	define('NO_POST_EDITOR_BUILD', true);
	build_all_styles();
	}

	function runQueries($DB,$Type,$Action,$TablePrefix){
	$this->buildQueries();

	$OurQueries = array();

		foreach($this->queries as $Q){
			if(in_array($Type,$Q['type'])){
				if(trim($Q[$Action]) != ''){
				$DB->query(trim(str_replace('{TABLE_PREFIX}',$TablePrefix,$Q[$Action])));
				}
			}
		}
	}

	function run_Fresh($DB,$Type,$XML,$TablePrefix){
	global $vbulletin, $vbphrase;

	$this->installQuizTemplates($DB,$TablePrefix,$XML);
	$this->runQueries($DB,$Type,'install',$TablePrefix);
	}

	function run_Upgrade_1($DB,$Type,$XML,$TablePrefix){
	global $vbulletin, $vbphrase;

	$this->killQuizTemplates($DB,$TablePrefix);
	$this->installQuizTemplates($DB,$TablePrefix,$XML);
	$this->runQueries($DB,$Type,'install',$TablePrefix);
	}

	function run_Uninstall($DB,$Type,$XML,$TablePrefix){
	global $vbulletin, $vbphrase;

	$this->killQuizTemplates($DB,$TablePrefix);
	$this->runQueries($DB,'Fresh','uninstall',$TablePrefix);
	}

	function run_Template($DB,$Type,$XML,$TablePrefix){
	global $vbulletin, $vbphrase;

	$this->killQuizTemplates($DB,$TablePrefix);
	$this->installQuizTemplates($DB,$TablePrefix,$XML);
	}

}

$Engine = new SystemRoutine;

print_cp_header(" ");

$Options = "";

	foreach($Engine->options as $val => $Opt){
	$Options .= "<option value='{$val}'>{$Opt}</option>\n";
	}

if ($_POST['do']==""){
	print_form_header('install_quiz', 'install_type');
	print_table_header(" ");
	print_description_row("
	     ...       .
	<select name='itype' class='button'>
	{$Options}
	</select>
	");
	print_submit_row("", 0);
	
}

// #############################################################################
// Install Type
if ($_POST['do']=="install_type"){

	if($Engine->options[$_POST['itype']]){

	$Type = $Engine->options[$_POST['itype']];

		print_form_header('install_quiz', '');
		print_table_header(" ");
		echo "<input type='hidden' value='{$_POST['itype']}' name='type' />";
		print_description_row("   '{$Type}'.    ");
		print_submit_row("", 0);
	} else {
		print_form_header('install_quiz', '');
		print_table_header("");
		print_description_row("   ...    ");
		print_submit_row("", 0);
	}

}

// #############################################################################
// step 1
if($_POST['do'] == ""){
require_once(DIR . '/includes/adminfunctions_template.php');



	print_form_header('', '');
	print_table_header(" ");
	print_description_row("   ...   .");

		if(!($xml = file_read('./'.$vbulletin->datastore->registry->config[Misc][admincpdir].'/quiz.xml'))){
		echo " - /{$admincpdir}/quiz.xml   -     .";
		exit;
		}

	$Type = $_POST[type];

		switch($Type){

		case 'Fresh':
		$Engine->run_Fresh($db,$Type,$xml,TABLE_PREFIX);
		break;

		case 'Upgrade_1':
		$Engine->run_Upgrade_1($db,$Type,$xml,TABLE_PREFIX);
		break;

		case 'Uninstall':
		$Engine->run_Uninstall($db,$Type,$xml,TABLE_PREFIX);
		break;

		case 'Template':
		$Engine->run_Template($db,$Type,$xml,TABLE_PREFIX);
		break;

		default:
		print_description_row("<i>   </i>");
		break;
		}

	print_description_row("<b>  </b>");
}
?>